<?php
  session_start();
  header("Content-Type: image/png");

  function imagelinethick($image, $x1, $y1, $x2, $y2, $color, $thick = 1)
  {
    /* this way it works well only for orthogonal lines
    imagesetthickness($image, $thick);
    return imageline($image, $x1, $y1, $x2, $y2, $color);
    */
    if ($thick == 1) {
        return imageline($image, $x1, $y1, $x2, $y2, $color);
    }
    $t = $thick / 2 - 0.5;
    if ($x1 == $x2 || $y1 == $y2) {
        return imagefilledrectangle($image, round(min($x1, $x2) - $t), round(min($y1, $y2) - $t), round(max($x1, $x2) + $t), round(max($y1, $y2) + $t), $color);
    }
    $k = ($y2 - $y1) / ($x2 - $x1); //y = kx + q
    $a = $t / sqrt(1 + pow($k, 2));
    $points = array(
        round($x1 - (1+$k)*$a), round($y1 + (1-$k)*$a),
        round($x1 - (1-$k)*$a), round($y1 - (1+$k)*$a),
        round($x2 + (1+$k)*$a), round($y2 - (1-$k)*$a),
        round($x2 + (1-$k)*$a), round($y2 + (1+$k)*$a),
    );
    imagefilledpolygon($image, $points, 4, $color);
    return imagepolygon($image, $points, 4, $color);
}



  include("blibadc.inc");
  $code="123456";$debut="2020/01/01";$fin="2020/06/01";
  $code=$_POST["code"];
  $debut=$_POST["debut"];
  $fin=$_POST["fin"];
  if($debut==""){$debut=date("Y")."/01/01";}
  if($fin==""){$fin=date("Y/m/d");}

  $description="Produit X";
  //lecture  de l'item
  $sql= "select description from liste where code=?";
  $stmt=$mysqli->prepare($sql);
  $stmt->bind_param("s",$code);
  $stmt->execute();
  $stmt->bind_result($description);
  $stmt->fetch();
  $stmt->close();

  $sql= "select min(nouveau),max(nouveau) from histoprix where code=? and ladate>=? and ladate<=? order by ladate";
  $stmt=$mysqli->prepare($sql);
  $stmt->bind_param("sss",$code,$debut,$fin);
  $stmt->execute();
  $stmt->bind_result($minprix,$maxprix);
  $stmt->fetch();
  $stmt->close();

  $sql= "select count(recid) from histoprix where code=? and ladate>=? and ladate<=? order by ladate";
  $stmt=$mysqli->prepare($sql);
  $stmt->bind_param("sss",$code,$debut,$fin);
  $stmt->execute();
  $stmt->bind_result($combien);
  $stmt->fetch();
  $stmt->close();
  $combien--;

  $maxx=1400;$maxy=600;
  $im = @imagecreate($maxx, $maxy ) or die("Cannot Initialize new GD image stream");
  $background = imagecolorallocate($im, 255, 255, 255);
  //$background = imagecolorallocate($im, 0, 0, 0);
  $black = imagecolorallocate($im, 0, 0, 0);
  $blue = imagecolorallocate($im, 0, 0, 255);
  $green = imagecolorallocate($im, 0, 255, 0);
  $red = imagecolorallocate($im, 255, 0, 0);
  $gris = imagecolorallocate($im, 205, 255, 205);
  //imagestring($im, 5, 150, 1, $texte, $blue);

  //******* legende
  $texte="Historique des prix du ".$debut. " au ".$fin;
  imagestring($im, 5, 50, 5, $texte, $blue);
  $texte="Item: ".$code. "   ".$description;
  imagestring($im, 5, 50, 20, $texte, $blue);
  $texte="Min: ".$minprix. "$   Max:".$maxprix."$";
  imagestring($im, 5, 50, 35, $texte, $blue);

   //****************affichage de sprix

  $sql= "select ladate,nouveau from histoprix where code=? and ladate>=? and ladate<=? order by ladate";
  $stmt=$mysqli->prepare($sql);
  $stmt->bind_param("sss",$code,$debut,$fin);
  $stmt->execute();
  $stmt->bind_result($date,$prix);
  $intervalley=intval($maxprix-$minprix);
  //$deltay=intval($maxy/$intervalley/2);
  $deltay=intval($maxy/$maxprix);
  $deltax=intval($maxx/$combien);
  if(($deltay>0)&&($deltay<1)){$deltay=0.1;}
  if(($deltay>0)&&($deltay<10)){$deltay=10;}
  if(($deltay>=10)&&($deltay<25)){$deltay=25;}
  if(($deltay>=25)&&($deltay<50)){$deltay=50;}
$deltay=10;
  $texte="Deltay:" ."$deltay";
//imagestring($im, 5, 400, 50, $texte, $blue);
  $x=200; $points=0;
  $deltax=intval($maxx/$combien/2);//200;
  while($stmt->fetch())
  {
    $date=substr($date,5,6);
    if($points<1)
    {
      $premierprix=$prix;
      $y=intval($prix/$maxprix*$maxy)-100;
      $y=$maxy-intval(($maxprix-$prix)*50)-200;
      $y=$maxy-intval($prix*$deltay);
      $texte=$prix."$";
imagestring($im, 5, $x, $y, $texte, $blue);
      $texte=$date;
imagestring($im, 3, $x, $y+15, $texte, $blue);
      $texte="100%";
imagestring($im, 5, $x, $y+25, $texte, $blue);
      //imagelinethick($im, $x, $y, $x, $y, $black, $thick = 1);
      $ancienx=$x;
      $ancieny=$y;
      $ancienprix=$prix;
      $points++;
    }
    else
    {
      $pc=intval($prix/$premierprix*100);
      $ancienprix=$prix;
      $y=intval($prix/$maxprix*$maxy)-100;

      $y=$maxy-intval($prix*$deltay);
//echo "DELTAY:$deltay, PRIX:$prix, X:$x, Y:$y <br>";

      $x=intval($x+$deltax);
      //$y=$maxy-$y;
      if($x>=$maxx){$posx=$maxx-50;}else{$posx=$x-20;}
      $posy=$y-20;
      $texte=$prix."$";
imagestring($im, 5, $posx, $posy, $texte, $blue);
      $texte=$date;
imagestring($im, 3, $posx, $posy+25, $texte, $blue);
      $texte=$pc."%";
imagestring($im, 3, $posx, $posy+40, $texte, $blue);
imagelinethick($im, $ancienx, $ancieny, $x, $y, $black, $thick = 1);
imagelinethick($im, $x, $y-5, $x, $y+5, $blue, $thick = 2);
imagelinethick($im, $x-5, $y, $x+5, $y, $blue, $thick = 2);


      $ancienx=$x;$ancieny=$y;
    }
  }
  $stmt->close();
  $diff=$pc-100;
  if($diff>0){$texte="Augmentation de ".$diff."%";}
  if($diff<0){$texte="Diminution de ".$diff."%";}
  imagestring($im, 5, 50, 50, $texte, $blue);





imagepng($im);
imagedestroy($im);

?>